"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNavigationTreeDefinition = void 0;
var _rxjs = require("rxjs");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _i18n = require("@kbn/i18n");
var _routes = require("./applications/applications/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.headerSolutionSwitcher.searchSolutionTitle', {
  defaultMessage: 'Elasticsearch'
});
const icon = 'logoElasticsearch';
const euiItemTypeToNodeDefinition = ({
  items,
  href,
  iconToString,
  id,
  isSelected = false,
  name,
  nameToString,
  onClick
}) => {
  const isAccordion = items !== undefined;
  const node = {
    children: isAccordion ? items.map(euiItemTypeToNodeDefinition) : undefined,
    getIsActive: () => isSelected,
    href,
    icon: iconToString,
    id: `${id}`,
    onClick: onClick ? e => {
      e.stopPropagation();
      onClick(e);
    } : undefined,
    title: typeof name === 'string' ? name : nameToString,
    ...(isAccordion ? {
      isCollapsible: false,
      renderAs: 'accordion'
    } : {})
  };
  return node;
};
const getNavigationTreeDefinition = ({
  dynamicItems$
}) => {
  return {
    dataTestSubj: 'searchSideNav',
    homePage: _deeplinksSearch.SEARCH_HOMEPAGE,
    icon,
    id: 'es',
    navigationTree$: dynamicItems$.pipe((0, _rxjs.debounceTime)(10), (0, _rxjs.map)(({
      searchApps,
      collections
    }) => {
      const navTree = {
        body: [{
          breadcrumbStatus: 'hidden',
          children: [{
            getIsActive: ({
              pathNameSerialized,
              prepend
            }) => {
              return pathNameSerialized.startsWith(prepend('/app/elasticsearch/overview')) || pathNameSerialized.startsWith(prepend('/app/elasticsearch/start'));
            },
            link: _deeplinksSearch.SEARCH_HOMEPAGE,
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.home', {
              defaultMessage: 'Home'
            })
          }, {
            link: 'discover'
          }, {
            getIsActive: ({
              pathNameSerialized,
              prepend
            }) => {
              return pathNameSerialized.startsWith(prepend('/app/dashboards'));
            },
            link: 'dashboards'
          }, {
            children: [{
              getIsActive: ({
                pathNameSerialized,
                prepend
              }) => {
                return pathNameSerialized.startsWith(prepend('/app/elasticsearch/index_management/indices')) || pathNameSerialized.startsWith(prepend('/app/elasticsearch/indices'));
              },
              link: 'elasticsearchIndexManagement'
            }, {
              breadcrumbStatus: 'hidden',
              link: 'searchPlayground'
            }, {
              link: 'enterpriseSearchContent:connectors'
            }, {
              getIsActive: ({
                pathNameSerialized,
                prepend
              }) => {
                const someSubItemSelected = searchApps === null || searchApps === void 0 ? void 0 : searchApps.some(app => {
                  var _app$items;
                  return (_app$items = app.items) === null || _app$items === void 0 ? void 0 : _app$items.some(item => item.isSelected);
                });
                if (someSubItemSelected) return false;
                return pathNameSerialized === prepend(`/app/elasticsearch/applications${_routes.SEARCH_APPLICATIONS_PATH}`);
              },
              link: 'enterpriseSearchApplications:searchApplications',
              renderAs: 'item',
              title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.build.searchApplications', {
                defaultMessage: 'Search applications'
              }),
              ...(searchApps ? {
                children: searchApps.map(euiItemTypeToNodeDefinition),
                isCollapsible: false,
                renderAs: 'accordion'
              } : {})
            }, {
              getIsActive: ({
                pathNameSerialized,
                prepend
              }) => {
                const someSubItemSelected = collections === null || collections === void 0 ? void 0 : collections.some(collection => {
                  var _collection$items;
                  return (_collection$items = collection.items) === null || _collection$items === void 0 ? void 0 : _collection$items.some(item => item.isSelected);
                });
                if (someSubItemSelected) return false;
                return pathNameSerialized === prepend(`/app/elasticsearch/analytics`);
              },
              link: 'enterpriseSearchAnalytics',
              renderAs: 'item',
              sideNavStatus: collections !== null && collections !== void 0 && collections.some(collection => {
                var _collection$items2;
                return (_collection$items2 = collection.items) === null || _collection$items2 === void 0 ? void 0 : _collection$items2.some(item => item.isSelected);
              }) ? 'visible' : 'hidden',
              ...(collections ? {
                children: collections.map(euiItemTypeToNodeDefinition),
                isCollapsible: false,
                renderAs: 'accordion'
              } : {})
            }],
            id: 'build',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.build', {
              defaultMessage: 'Build'
            })
          }, {
            children: [{
              link: 'searchSynonyms:synonyms'
            }, {
              link: 'searchQueryRules'
            }, {
              link: 'searchInferenceEndpoints:inferenceEndpoints'
            }],
            id: 'relevance',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.relevance', {
              defaultMessage: 'Relevance'
            })
          }],
          defaultIsCollapsed: false,
          icon,
          id: 'search_project_nav',
          isCollapsible: false,
          title,
          type: 'navGroup'
        }],
        footer: [{
          children: [{
            getIsActive: ({
              pathNameSerialized,
              prepend
            }) => {
              return pathNameSerialized.startsWith(prepend('/app/dev_tools'));
            },
            id: 'dev_tools',
            link: 'dev_tools',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.devTools', {
              defaultMessage: 'Dev Tools'
            })
          }, {
            breadcrumbStatus: 'hidden',
            children: [{
              link: 'management:trained_models',
              title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.trainedModels', {
                defaultMessage: 'Trained Models'
              })
            }, {
              children: [{
                children: [{
                  link: 'management:ingest_pipelines'
                }, {
                  link: 'management:pipelines'
                }],
                title: 'Ingest'
              }, {
                children: [{
                  link: 'management:index_management'
                }, {
                  link: 'management:index_lifecycle_management'
                }, {
                  link: 'management:snapshot_restore'
                }, {
                  link: 'management:rollup_jobs'
                }, {
                  link: 'management:transform'
                }, {
                  link: 'management:cross_cluster_replication'
                }, {
                  link: 'management:remote_clusters'
                }, {
                  link: 'management:migrate_data'
                }],
                title: 'Data'
              }, {
                children: [{
                  link: 'management:triggersActions'
                }, {
                  link: 'management:cases'
                }, {
                  link: 'management:triggersActionsConnectors'
                }, {
                  link: 'management:reporting'
                }, {
                  link: 'management:jobsListLink'
                }, {
                  link: 'management:watcher'
                }, {
                  link: 'management:maintenanceWindows'
                }],
                title: 'Alerts and Insights'
              }, {
                children: [{
                  link: 'management:trained_models'
                }],
                title: 'Machine Learning'
              }, {
                children: [{
                  link: 'management:users'
                }, {
                  link: 'management:roles'
                }, {
                  link: 'management:api_keys'
                }, {
                  link: 'management:role_mappings'
                }],
                title: 'Security'
              }, {
                children: [{
                  link: 'management:dataViews'
                }, {
                  link: 'management:filesManagement'
                }, {
                  link: 'management:objects'
                }, {
                  link: 'management:tags'
                }, {
                  link: 'management:search_sessions'
                }, {
                  link: 'management:aiAssistantManagementSelection'
                }, {
                  link: 'management:spaces'
                }, {
                  link: 'management:settings'
                }],
                title: 'Kibana'
              }, {
                children: [{
                  link: 'management:license_management'
                }, {
                  link: 'management:upgrade_assistant'
                }],
                title: 'Stack'
              }],
              id: 'stack_management',
              // This id can't be changed as we use it to open the panel programmatically
              renderAs: 'panelOpener',
              spaceBefore: null,
              title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.mngt', {
                defaultMessage: 'Stack Management'
              })
            }, {
              id: 'monitoring',
              link: 'monitoring'
            }],
            icon: 'gear',
            id: 'project_settings_project_nav',
            renderAs: 'accordion',
            spaceBefore: null,
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management', {
              defaultMessage: 'Management'
            })
          }],
          id: 'search_project_nav_footer',
          type: 'navGroup'
        }]
      };
      return navTree;
    })),
    title
  };
};
exports.getNavigationTreeDefinition = getNavigationTreeDefinition;