"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationSchema = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactField = require("@kbn/react-field");
var _constants = require("../../../../../common/constants");
var _routes = require("../../../enterprise_search_content/routes");
var _doc_links = require("../../../shared/doc_links");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _search_application_view_logic = require("./search_application_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaFieldDetails = ({
  schemaField
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const notInAllIndices = schemaField.indices.some(i => i.type === 'unmapped');
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.index.columnTitle', {
      defaultMessage: 'Parent index'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: `${_constants.ENTERPRISE_SEARCH_DATA_PLUGIN.URL}${(0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName: name,
        tabId: 'index_mappings'
      })}`
    }, name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.type.columnTitle', {
      defaultMessage: 'Field mapped as'
    }),
    render: name => {
      if (name === 'unmapped') return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.type.unmapped",
        defaultMessage: "Unmapped"
      }));
      return name;
    }
  }, {
    actions: [{
      description: 'View index mappings',
      icon: 'eye',
      name: 'View index',
      onClick: item => {
        navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName: item.name,
          tabId: 'index_mappings'
        }));
      },
      type: 'icon'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, notInAllIndices && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.title",
      defaultMessage: "This field is not mapped in every index."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.description",
    defaultMessage: "Learn more about field mapping in"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.elasticsearchMapping,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.fieldIndices.notInAllIndices.link",
    defaultMessage: "our documentation."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    css: {
      '& .euiTable': {
        backgroundColor: 'transparent'
      }
    },
    columns: columns,
    items: schemaField.indices,
    responsiveBreakpoint: false
  })));
};
const SearchApplicationSchema = () => {
  const [onlyShowConflicts, setOnlyShowConflicts] = (0, _react.useState)(false);
  const {
    isLoadingSearchApplicationSchema,
    schemaFields,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const [isFilterByPopoverOpen, setIsFilterByPopoverOpen] = (0, _react.useState)(false);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  // get all the elasticsearch Field Types
  const esFieldTypes = Object.values(_fieldTypes.ES_FIELD_TYPES).map(fieldDataTypeName => ({
    checked: undefined,
    label: fieldDataTypeName.toString()
  }));
  const [selectedEsFieldTypes, setSelectedEsFieldTypes] = (0, _react.useState)(esFieldTypes);
  const toggleOnlyShowConflicts = (0, _react.useCallback)(() => {
    setOnlyShowConflicts(!onlyShowConflicts);
    setItemIdToExpandedRowMap({});
  }, [onlyShowConflicts]);

  // update filteredDataTypes as filter by field types are selected
  const filteredDataTypes = (0, _react.useMemo)(() => {
    const selectedDataTypes = selectedEsFieldTypes.filter(option => option.checked === 'on').map(option => option.label);
    return selectedDataTypes;
  }, [selectedEsFieldTypes]);

  // return schema fields may be with conflicts
  const schemaFieldsMaybeWithConflicts = (0, _react.useMemo)(() => {
    if (onlyShowConflicts) return schemaFields.filter(field => field.type === 'conflict');
    return schemaFields;
  }, [onlyShowConflicts, schemaFields]);
  const filteredSchemaFields = (0, _react.useMemo)(() => {
    if (filteredDataTypes.length > 0) return schemaFieldsMaybeWithConflicts.filter(field => field.indices.some(i => filteredDataTypes.includes(i.type)));
    return schemaFieldsMaybeWithConflicts;
  }, [onlyShowConflicts, schemaFields, filteredDataTypes]);
  const totalConflictsHiddenByTypeFilters = onlyShowConflicts ? schemaFieldsMaybeWithConflicts.length - filteredSchemaFields.length : 0;
  const toggleDetails = schemaField => {
    const newItemIdToExpandedRowMap = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMap[schemaField.name]) {
      delete newItemIdToExpandedRowMap[schemaField.name];
    } else {
      newItemIdToExpandedRowMap[schemaField.name] = /*#__PURE__*/_react.default.createElement(SchemaFieldDetails, {
        schemaField: schemaField
      });
    }
    setItemIdToExpandedRowMap(newItemIdToExpandedRowMap);
  };
  const columns = [{
    render: ({
      type
    }) => {
      if (type !== 'conflict') return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        color: "danger"
      });
    },
    width: '24px'
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_name.columnTitle', {
      defaultMessage: 'Field name'
    }),
    render: ({
      name,
      type
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, name.includes('.') && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortRight",
      color: "subdued"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: type === 'conflict' ? 'danger' : 'primary'
    }, /*#__PURE__*/_react.default.createElement("p", null, name)))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_type.columnTitle', {
      defaultMessage: 'Field type'
    }),
    render: ({
      type
    }) => {
      if (type === 'conflict') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "danger"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_type.conflict",
          defaultMessage: "Conflict"
        })));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: type
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, type)));
    },
    width: '180px'
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.columnTitle', {
      defaultMessage: 'In all indices?'
    }),
    render: ({
      indices
    }) => {
      const inAllIndices = indices.every(i => i.type !== 'unmapped');
      return inAllIndices ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.yes",
        defaultMessage: "Yes"
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.no",
        defaultMessage: "No"
      }));
    },
    width: '110px'
  }, {
    isExpander: true,
    render: schemaField => {
      const {
        name,
        type,
        indices
      } = schemaField;
      if (type === 'conflict' || indices.some(i => i.type === 'unmapped')) {
        const icon = itemIdToExpandedRowMap[name] ? 'arrowUp' : 'arrowDown';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          justifyContent: "flexEnd"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          size: "s",
          color: "primary",
          iconType: icon,
          iconSide: "right",
          onClick: () => {
            toggleDetails(schemaField);
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.field_indices.moreInfo",
          defaultMessage: "More info"
        })));
      }
      return null;
    },
    width: '115px'
  }];
  const filterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setIsFilterByPopoverOpen(!isFilterByPopoverOpen),
    numFilters: selectedEsFieldTypes.length,
    hasActiveFilters: filteredDataTypes.length > 0,
    numActiveFilters: filteredDataTypes.length,
    isSelected: isFilterByPopoverOpen
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters', {
    defaultMessage: 'Field types'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.title', {
      defaultMessage: 'Potential field mapping issues found'
    }),
    iconType: "error",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.description",
    defaultMessage: "Schema field type conflicts can be resolved by navigating to the source index directly and updating the field type of the conflicting field(s) to match that of the other source indices."
  })), !onlyShowConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    onClick: toggleOnlyShowConflicts
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.conflictsCallOut.button",
    defaultMessage: "View conflicts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.onlyShowConflicts', {
      defaultMessage: 'Only show conflicts'
    }),
    checked: onlyShowConflicts,
    onChange: toggleOnlyShowConflicts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.label', {
    defaultMessage: 'Filter By'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: filterButton,
    isOpen: isFilterByPopoverOpen,
    closePopover: () => setIsFilterByPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.searchPlaceholder', {
        defaultMessage: 'Filter list '
      })
    },
    options: selectedEsFieldTypes,
    onChange: options => setSelectedEsFieldTypes(options)
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconType: "eraser",
    size: "s",
    onClick: () => setSelectedEsFieldTypes(esFieldTypes)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.clearAll', {
    defaultMessage: 'Clear all '
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: filteredSchemaFields,
    columns: columns,
    loading: isLoadingSearchApplicationSchema,
    itemId: "name",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    responsiveBreakpoint: false
  }), totalConflictsHiddenByTypeFilters > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.title",
      defaultMessage: "There are {totalConflictsHiddenByTypeFilters, number} more {totalConflictsHiddenByTypeFilters, plural, one {conflict} other {conflicts}}   not displayed here",
      values: {
        totalConflictsHiddenByTypeFilters
      }
    }),
    color: "danger",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.subTitle', {
    defaultMessage: 'In order to see all field conflicts you must clear your field filters'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "danger",
    onClick: () => setSelectedEsFieldTypes(esFieldTypes)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.schema.filters.conflict.callout.clearFilters', {
    defaultMessage: 'Clear filters '
  })))));
};
exports.SearchApplicationSchema = SearchApplicationSchema;