"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RrfRankingPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingPanel.step1.title', {
    defaultMessage: 'Discover examples of using RRF in _search queries'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchReciprocalRankFusionDocumentationLink",
    "data-telemetry-id": "entSearch-aiSearch-rankAggregation-rrfRankingPanel-rrfDocsLink",
    href: _doc_links.docLinks.rrf,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingPanel.step1.rrfDocsLinkText', {
    defaultMessage: 'Reciprocal Rank Fusion documentation'
  })),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingPanel.step2.title', {
    defaultMessage: 'Example Python Code'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchLink",
    "data-telemetry-id": "entSearch-aiSearch-rankAggregation-rrfRankingPanel-devToolsConsoleButton",
    href: _doc_links.docLinks.searchLabsRepo + 'blob/main/notebooks/search/02-hybrid-search.ipynb',
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingPanel.step2.buttonLabel', {
    defaultMessage: 'View Notebook'
  })),
  status: 'incomplete'
}];
const RrfRankingPanel = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.rrfRankingPanel.description",
  "data-telemetry-id": "entSearch-aiSearch-semanticSearch-rrfRankingPanel-rrfDocsLink",
  defaultMessage: "Use {rrf} to combine rankings from multiple result sets with different relevance indicators, with no fine tuning required.",
  values: {
    rrf: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "enterpriseSearchRrfRankingPanelReciprocalRankFusionRrfLink",
      target: "_blank",
      href: _doc_links.docLinks.rrf,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingPanel.rrfLinkText', {
      defaultMessage: 'Reciprocal Rank Fusion (RRF)'
    }))
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  steps: steps,
  titleSize: "xs"
}))));
exports.RrfRankingPanel = RrfRankingPanel;