"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRetrieveAnonymizedEventsNode = void 0;
var _anonymized_events_retriever = require("./anonymized_events_retriever");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRetrieveAnonymizedEventsNode = ({
  insightType,
  endpointIds,
  anonymizationFields,
  esClient,
  logger,
  onNewReplacements,
  replacements,
  size
}) => {
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  const retrieveAnonymizedEvents = async state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---RETRIEVE ANONYMIZED EVENTS---');
    const {
      start,
      end
    } = state;
    const retriever = new _anonymized_events_retriever.AnonymizedEventsRetriever({
      insightType,
      endpointIds,
      anonymizationFields,
      esClient,
      onNewReplacements: localOnNewReplacements,
      replacements,
      size,
      start,
      end
    });
    const documents = await retriever.withConfig({
      runName: 'runAnonymizedEventsRetriever'
    }).invoke('');
    return {
      ...state,
      anonymizedDocuments: documents,
      replacements: localReplacements
    };
  };
  return retrieveAnonymizedEvents;
};
exports.getRetrieveAnonymizedEventsNode = getRetrieveAnonymizedEventsNode;