"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.existsQuery = existsQuery;
exports.isUndefinedOrNull = isUndefinedOrNull;
exports.rangeQuery = rangeQuery;
exports.wildcardQuery = wildcardQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isUndefinedOrNull(value) {
  return value === undefined || value === null;
}
function wildcardQuery(field, value) {
  if (isUndefinedOrNull(value) || value === '') {
    return [];
  }
  return [{
    wildcard: {
      [field]: `*${value}*`
    }
  }];
}
function rangeQuery(start, end, field = '@timestamp') {
  return [{
    range: {
      [field]: {
        gte: start,
        lte: end,
        format: 'epoch_millis'
      }
    }
  }];
}
function existsQuery(field) {
  return [{
    exists: {
      field
    }
  }];
}