"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClustersProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _api = require("../services/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-line no-unused-vars

class RemoteClustersProvider extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: true,
      error: null,
      remoteClusters: []
    });
  }
  componentDidMount() {
    this.loadRemoteClusters();
  }
  loadRemoteClusters() {
    const sortClusterByName = remoteClusters => remoteClusters.sort((a, b) => {
      if (a.name < b.name) {
        return -1;
      }
      if (a.name > b.name) {
        return 1;
      }
      return 0;
    });
    (0, _api.loadRemoteClusters)().then(sortClusterByName).then(remoteClusters => {
      this.setState({
        isLoading: false,
        remoteClusters
      });
    }).catch(error => {
      this.setState({
        isLoading: false,
        error
      });
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isLoading,
      error,
      remoteClusters
    } = this.state;
    return children({
      isLoading,
      error,
      remoteClusters
    });
  }
}
exports.RemoteClustersProvider = RemoteClustersProvider;