"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmConfig = void 0;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _apmConfigLoader = require("@kbn/apm-config-loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OMIT_APM_CONFIG = ['secretToken', 'apiKey', 'captureSpanStackTraces', 'metricsInterval'];
const getApmConfig = requestPath => {
  const baseConfig = (0, _apmConfigLoader.getConfiguration)('kibana-frontend') || {};

  // Omit configs not used by RUM agent.
  OMIT_APM_CONFIG.forEach(config => {
    delete baseConfig[config];
  });
  if (!(0, _apmConfigLoader.shouldInstrumentClient)(baseConfig)) {
    return null;
  }

  // Cleanup RUM unsupported attrbiutes from base apm config.
  const {
    contextPropagationOnly,
    ...restOfConfig
  } = baseConfig;
  const config = {
    ...restOfConfig,
    pageLoadTransactionName: requestPath
  };

  // Get current active backend transaction to make distributed tracing
  // work for rendering the app
  const backendTransaction = _elasticApmNode.default.currentTransaction;
  if (backendTransaction) {
    var _agent$currentSpan, _agent$currentTransac;
    const {
      sampled,
      traceId
    } = backendTransaction;
    return {
      ...config,
      pageLoadTraceId: traceId,
      pageLoadSampled: sampled,
      pageLoadParentId: ((_agent$currentSpan = _elasticApmNode.default.currentSpan) === null || _agent$currentSpan === void 0 ? void 0 : _agent$currentSpan.ids['span.id']) || ((_agent$currentTransac = _elasticApmNode.default.currentTransaction) === null || _agent$currentTransac === void 0 ? void 0 : _agent$currentTransac.ids['transaction.id'])
    };
  }
  return config;
};
exports.getApmConfig = getApmConfig;