"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWarning = TraceWarning;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _use_trace_waterfall = require("./use_trace_waterfall");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceWarning({
  children
}) {
  const {
    traceState,
    message
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  switch (traceState) {
    case _use_trace_waterfall.TraceDataState.Partial:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "traceWarning",
        color: "warning",
        size: "s",
        title: message
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children));
    case _use_trace_waterfall.TraceDataState.Empty:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "traceWarning",
        color: "warning",
        size: "s",
        title: message
      });
    case _use_trace_waterfall.TraceDataState.Invalid:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "traceWarning",
        color: "danger",
        size: "s",
        title: message
      });
    default:
      return children;
  }
}