"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexFlyoutStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../../../../../common/types");
var _types2 = require("../../../../../../types");
var _progress = require("./progress");
var _app_context = require("../../../../../../../app_context");
var _callouts = require("../callouts");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buttonLabel = status => {
  switch (status) {
    case _types.ReindexStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexButton.tryAgainLabel",
        defaultMessage: "Try again"
      });
    case _types.ReindexStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexButton.reindexingLabel",
        defaultMessage: "Reindexing\u2026"
      });
    case _types.ReindexStatus.paused:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexButton.resumeLabel",
        defaultMessage: "Resume reindexing"
      });
    case _types.ReindexStatus.cancelled:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexButton.restartLabel",
        defaultMessage: "Restart reindexing"
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexButton.runReindexLabel",
        defaultMessage: "Start reindexing"
      });
  }
};

/**
 * Displays a flyout that shows the current reindexing status for a given index.
 */
const ReindexFlyoutStep = ({
  closeFlyout,
  reindexState,
  startReindex,
  cancelReindex
}) => {
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    loadingState,
    status,
    hasRequiredPrivileges
  } = reindexState;
  const loading = loadingState === _types2.LoadingState.Loading || status === _types.ReindexStatus.inProgress;
  const isCompleted = status === _types.ReindexStatus.completed;
  const hasFetchFailed = status === _types.ReindexStatus.fetchFailed;
  const hasReindexingFailed = status === _types.ReindexStatus.failed;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, reindexState.meta.isFrozen && /*#__PURE__*/_react.default.createElement(_callouts.FrozenCallOut, null), hasRequiredPrivileges === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.insufficientPrivilegeCallout.calloutTitle",
      defaultMessage: "You do not have sufficient privileges to reindex this index"
    }),
    color: "danger",
    iconType: "warning"
  })), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  }), hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage
  }), !hasFetchFailed && hasReindexingFailed && /*#__PURE__*/_react.default.createElement(_callouts.ReindexingFailedCallOut, {
    errorMessage: reindexState.errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexDescription",
    defaultMessage: "The index will be read-only during reindexing. You won't be able to add, update, or delete documents until reindexing is complete. If you need to reindex to a new cluster, use the reindex API. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinks.links.upgradeAssistant.remoteReindex
      }, _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.learnMoreLinkLabel', {
        defaultMessage: 'Learn more'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.readonlyCallout.backgroundResumeDetail",
    defaultMessage: "Reindexing is performed in the background. You can return to the Upgrade Assistant to view progress or resume reindexing after a Kibana restart."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_progress.ReindexProgress, {
    reindexState: reindexState,
    cancelReindex: cancelReindex
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.closeButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, !hasFetchFailed && !isCompleted && hasRequiredPrivileges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: status === _types.ReindexStatus.paused ? 'warning' : 'primary',
    iconType: status === _types.ReindexStatus.paused ? 'play' : undefined,
    onClick: startReindex,
    isLoading: loading,
    disabled: loading || !hasRequiredPrivileges,
    "data-test-subj": "startReindexingButton"
  }, buttonLabel(status)))))));
};
exports.ReindexFlyoutStep = ReindexFlyoutStep;