"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthIndicatorFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared = require("../../../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.healthIndicatorFlyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  healthIndicatorCauseHeader: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.healthIndicatorFlyout.healthIndicatorCauseHeader', {
    defaultMessage: 'Cause'
  }),
  healthIndicatorActionHeader: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.healthIndicatorFlyout.healthIndicatorActionHeader', {
    defaultMessage: 'Action'
  }),
  healthIndicatorImpactHeader: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.healthIndicatorFlyout.healthIndicatorImpactHeader', {
    defaultMessage: 'Impact'
  })
};
const HealthIndicatorFlyout = ({
  deprecation,
  closeFlyout
}) => {
  const {
    message,
    url,
    details,
    correctiveAction
  } = deprecation;
  const {
    action,
    cause,
    impacts
  } = correctiveAction;
  const showAction = Boolean(action && action !== '');
  const showLearnMore = Boolean(url && url !== '');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "defaultDeprecationDetailsFlyoutTitle"
  }, message))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord"
  }, details)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18nTexts.healthIndicatorCauseHeader)), /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord"
  }, cause)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), showAction && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18nTexts.healthIndicatorActionHeader)), /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord"
  }, action)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18nTexts.healthIndicatorImpactHeader)), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true
  }, JSON.stringify(impacts, null, 2))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), showLearnMore && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: url
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18nTexts.closeButtonLabel)))));
};
exports.HealthIndicatorFlyout = HealthIndicatorFlyout;