"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexWarningCallout = exports.ReadonlyWarningCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReindexWarningCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.reindex.calloutTitle",
      defaultMessage: "This operation requires destructive changes that cannot be reversed"
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "reindexDsWarningCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.reindex.calloutDetail",
    defaultMessage: "Ensure data has been backed up before continuing. To proceed with reindexing this data, confirm below."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ReindexWarningCallout = ReindexWarningCallout;
const ReadonlyWarningCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.readonly.calloutTitle",
      defaultMessage: "Setting this data to read-only could affect some of the existing setups"
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "readOnlyDsWarningCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.readonly.calloutDetail",
    defaultMessage: "Make sure you have backed up your data, etc. You can always re-index this data later to make it editable."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ReadonlyWarningCallout = ReadonlyWarningCallout;