"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChecklistModalStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../../../../common/types");
var _types2 = require("../../../../../../types");
var _progress = require("./progress");
var _app_context = require("../../../../../../../app_context");
var _messages = require("../../messages");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
var _callouts = require("./callouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays a flyout that shows the current reindexing status for a given index.
 */
const ChecklistModalStep = ({
  closeModal,
  migrationState,
  executeAction,
  cancelAction,
  dataStreamName
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    loadingState,
    status,
    hasRequiredPrivileges
  } = migrationState;
  const loading = loadingState === _types2.LoadingState.Loading || status === _types.DataStreamMigrationStatus.inProgress;
  const isCompleted = status === _types.DataStreamMigrationStatus.completed;
  const hasFetchFailed = status === _types.DataStreamMigrationStatus.fetchFailed;
  const hasMigrationFailed = status === _types.DataStreamMigrationStatus.failed;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const showMainButton = !hasFetchFailed && !isCompleted && hasRequiredPrivileges;
  const shouldShowCancelButton = showMainButton && status === _types.DataStreamMigrationStatus.inProgress;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "readonlyDataStreamModalTitle",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.modal.checktlistStep.readonly.title",
    defaultMessage: "Setting data stream to read-only"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    "data-test-subj": "dataStreamMigrationChecklistModal"
  }, !hasRequiredPrivileges && /*#__PURE__*/_react.default.createElement(_callouts.NoPrivilegesCallout, null), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  }), (hasFetchFailed || hasMigrationFailed) && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallout, {
    hasFetchFailed: hasFetchFailed,
    errorMessage: migrationState.errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_progress.MigrationProgress, {
    migrationState: migrationState,
    dataStreamName: dataStreamName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.checklistStep.closeButtonLabel",
    defaultMessage: "Close"
  })), shouldShowCancelButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'accent',
    iconType: 'pause',
    onClick: cancelAction,
    disabled: !hasRequiredPrivileges,
    "data-test-subj": "cancelDataStreamMigrationButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.checklistStep.cancelMigrationButtonLabel",
    defaultMessage: "Cancel setting to read-only"
  }))), showMainButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: 'primary',
    iconType: status === _types.DataStreamMigrationStatus.inProgress ? undefined : 'refresh',
    onClick: executeAction,
    isLoading: loading,
    disabled: loading || !hasRequiredPrivileges,
    "data-test-subj": "startDataStreamMigrationButton"
  }, (0, _messages.getPrimaryButtonLabel)(status))))));
};
exports.ChecklistModalStep = ChecklistModalStep;