"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionButtons = ({
  actions,
  dataTestSubjPrefix
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, actions.filter(action => action.canDisplay).map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: action.resolutionType
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: action.tooltip
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  onClick: action.onClick,
  "data-test-subj": `deprecation-${dataTestSubjPrefix}-${action.resolutionType}`
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "primary",
  type: action.iconType,
  size: "m",
  "aria-label": action.tooltip
}))))));
exports.ActionButtons = ActionButtons;