"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ReindexStep: true,
  ReindexStatus: true,
  REINDEX_OP_TYPE: true,
  ML_UPGRADE_OP_TYPE: true
};
exports.ReindexStep = exports.ReindexStatus = exports.REINDEX_OP_TYPE = exports.ML_UPGRADE_OP_TYPE = void 0;
var _data_stream_types = require("./data_stream_types");
Object.keys(_data_stream_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _data_stream_types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _data_stream_types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ReindexStep = exports.ReindexStep = /*#__PURE__*/function (ReindexStep) {
  ReindexStep[ReindexStep["created"] = 0] = "created";
  ReindexStep[ReindexStep["readonly"] = 20] = "readonly";
  ReindexStep[ReindexStep["newIndexCreated"] = 30] = "newIndexCreated";
  ReindexStep[ReindexStep["reindexStarted"] = 40] = "reindexStarted";
  ReindexStep[ReindexStep["reindexCompleted"] = 50] = "reindexCompleted";
  ReindexStep[ReindexStep["indexSettingsRestored"] = 55] = "indexSettingsRestored";
  ReindexStep[ReindexStep["aliasCreated"] = 60] = "aliasCreated";
  ReindexStep[ReindexStep["originalIndexDeleted"] = 70] = "originalIndexDeleted";
  ReindexStep[ReindexStep["existingAliasesUpdated"] = 80] = "existingAliasesUpdated";
  return ReindexStep;
}({});
let ReindexStatus = exports.ReindexStatus = /*#__PURE__*/function (ReindexStatus) {
  ReindexStatus[ReindexStatus["inProgress"] = 0] = "inProgress";
  ReindexStatus[ReindexStatus["completed"] = 1] = "completed";
  ReindexStatus[ReindexStatus["failed"] = 2] = "failed";
  ReindexStatus[ReindexStatus["paused"] = 3] = "paused";
  ReindexStatus[ReindexStatus["cancelled"] = 4] = "cancelled";
  ReindexStatus[ReindexStatus["fetchFailed"] = 5] = "fetchFailed";
  return ReindexStatus;
}({});
const REINDEX_OP_TYPE = exports.REINDEX_OP_TYPE = 'upgrade-assistant-reindex-operation';

// 8.0 -> 9.0 warnings

// Telemetry types

const ML_UPGRADE_OP_TYPE = exports.ML_UPGRADE_OP_TYPE = 'upgrade-assistant-ml-upgrade-operation';