"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledDiv = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _use_memo_css = require("../use_memo_css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const queryStringInputStyles = {
  container: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    zIndex: _uiTheme.euiThemeVars.euiZContentMenu,
    height: euiTheme.size.xxl,
    display: 'flex',
    '> [aria-expanded="true"]': {
      // Using filter allows it to adhere the children's bounds
      filter: `drop-shadow(0 ${euiTheme.size.s} ${euiTheme.size.base} rgba(${euiTheme.colors.shadow}, 0.05))`
    },
    '.kbnQueryBar__textareaWrapOuter': {
      position: 'relative',
      width: '100%',
      zIndex: euiTheme.levels.flyout
    },
    '.kbnQueryBar__textareaWrap': {
      position: 'relative',
      overflow: 'visible !important',
      // Override EUI form control
      display: 'flex',
      flex: '1 1 100%',
      '&.kbnQueryBar__textareaWrap--withSuggestionVisible .kbnQueryBar__textarea': {
        borderBottomRightRadius: 0,
        borderBottomLeftRadius: 0
      },
      '> .euiFormControlLayoutIcons': {
        maxHeight: euiTheme.size.xxl
      }
    },
    '.kbnQueryBar__textarea': {
      zIndex: euiTheme.levels.content,
      height: euiTheme.size.xxl,
      // Unlike most inputs within layout control groups, the text area still needs a border
      // for multi-line content. These adjusts help it sit above the control groups
      // shadow to line up correctly.
      padding: euiTheme.size.s,
      paddingTop: `calc(${euiTheme.size.s} + 2px)`,
      paddingLeft: euiTheme.size.xxl,
      // Account for search icon
      // Firefox adds margin to textarea
      margin: 0,
      '&.kbnQueryBar__textarea--isClearable': {
        paddingRight: euiTheme.size.xxl // Account for clear button
      },
      '&:not(.kbnQueryBar__textarea--autoHeight)': {
        overflowY: 'hidden',
        overflowX: 'hidden'
      },
      // When focused, let it scroll
      '&.kbnQueryBar__textarea--autoHeight': {
        overflowX: 'auto',
        overflowY: 'auto',
        whiteSpace: `pre-wrap`,
        maxHeight: `calc(35vh - 100px)`,
        minHeight: euiTheme.size.xxl
      },
      '~.euiFormControlLayoutIcons': {
        // By default form control layout icon is vertically centered, but our textarea
        // can expand to be multi-line, so we position it with padding that matches
        // the parent textarea padding
        zIndex: euiTheme.levels.flyout,
        top: euiTheme.size.m,
        bottom: 'unset'
      },
      '&.kbnQueryBar__textarea--withPrepend': {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        marginLeft: '-1px',
        width: 'calc(100% + 1px)'
      }
    }
  })
};
const StyledDiv = ({
  children,
  ...props
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(queryStringInputStyles);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    css: styles.container
  }, props), children);
};
exports.StyledDiv = StyledDiv;