"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _change_dataview = require("./change_dataview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

const DataViewPicker = ({
  isMissingCurrent,
  currentDataViewId,
  adHocDataViews,
  managedDataViews,
  savedDataViews,
  onChangeDataView,
  onEditDataView,
  onAddField,
  onDataViewCreated,
  onClosePopover,
  trigger,
  selectableProps,
  onCreateDefaultAdHocDataView,
  isDisabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_change_dataview.ChangeDataView, {
    isMissingCurrent: isMissingCurrent,
    currentDataViewId: currentDataViewId,
    onChangeDataView: onChangeDataView,
    onEditDataView: onEditDataView,
    onAddField: onAddField,
    onDataViewCreated: onDataViewCreated,
    onClosePopover: onClosePopover,
    onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView,
    trigger: trigger,
    adHocDataViews: adHocDataViews,
    managedDataViews: managedDataViews,
    savedDataViews: savedDataViews,
    selectableProps: selectableProps,
    isDisabled: isDisabled
  });
};
exports.DataViewPicker = DataViewPicker;