"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverviewStacktraceSection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _stacktrace_content = require("./sub_components/stacktrace/stacktrace_content");
var _scrollable_section_wrapper = require("./scrollable_section_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const stacktraceAccordionTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.stacktrace', {
  defaultMessage: 'Stacktrace'
});
const LogsOverviewStacktraceSection = exports.LogsOverviewStacktraceSection = /*#__PURE__*/(0, _react.forwardRef)(({
  hit,
  dataView
}, ref) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: stacktraceAccordionTitle
  });
  return /*#__PURE__*/_react.default.createElement(_scrollable_section_wrapper.ScrollableSectionWrapper, {
    ref: ref
  }, ({
    forceState,
    onToggle
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, stacktraceAccordionTitle)),
    paddingSize: "m",
    forceState: forceState,
    onToggle: onToggle,
    "data-test-subj": "unifiedDocViewLogsOverviewStacktraceAccordion"
  }, /*#__PURE__*/_react.default.createElement(_stacktrace_content.StacktraceContent, {
    hit: hit,
    dataView: dataView
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })));
});