"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListStatuses = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesListStatuses = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    rulesStatuses,
    rulesLastRunOutcomes
  } = props;
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  if (isRuleUsingExecutionStatus) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: euiTheme.colors.success,
      "data-test-subj": "totalActiveRulesCount"
    }, (0, _translations.RULE_STATUS_ACTIVE)(rulesStatuses.active))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: euiTheme.colors.danger,
      "data-test-subj": "totalErrorRulesCount"
    }, (0, _translations.RULE_STATUS_ERROR)(rulesStatuses.error))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: euiTheme.colors.warning,
      "data-test-subj": "totalWarningRulesCount"
    }, (0, _translations.RULE_STATUS_WARNING)(rulesStatuses.warning))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: euiTheme.colors.primary,
      "data-test-subj": "totalOkRulesCount"
    }, (0, _translations.RULE_STATUS_OK)(rulesStatuses.ok))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: euiTheme.colors.accent,
      "data-test-subj": "totalPendingRulesCount"
    }, (0, _translations.RULE_STATUS_PENDING)(rulesStatuses.pending))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued",
      "data-test-subj": "totalUnknownRulesCount"
    }, (0, _translations.RULE_STATUS_UNKNOWN)(rulesStatuses.unknown))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: euiTheme.colors.success,
    "data-test-subj": "totalSucceededRulesCount"
  }, (0, _translations.RULE_LAST_RUN_OUTCOME_SUCCEEDED_DESCRIPTION)(rulesLastRunOutcomes.succeeded))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: euiTheme.colors.danger,
    "data-test-subj": "totalFailedRulesCount"
  }, (0, _translations.RULE_LAST_RUN_OUTCOME_FAILED_DESCRIPTION)(rulesLastRunOutcomes.failed))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: euiTheme.colors.warning,
    "data-test-subj": "totalWarningRulesCount"
  }, (0, _translations.RULE_LAST_RUN_OUTCOME_WARNING_DESCRIPTION)(rulesLastRunOutcomes.warning))));
};
exports.RulesListStatuses = RulesListStatuses;