"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileSelectablePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const iconButtonTitle = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.ruleExecutionPercentileSelectButton', {
  defaultMessage: 'select percentile'
});
const divStyle = {
  width: 200
};
const PercentileSelectablePopover = exports.PercentileSelectablePopover = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    options,
    onOptionsChange
  } = props;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(e => {
    // stop propagation to prevent clicking on the column header
    // which triggers a sorting call
    e.stopPropagation();
    setIsOpen(currentIsOpen => !currentIsOpen);
  }, []);
  const onPopoverClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  const onOptionsChangeAndClosePopover = (0, _react.useCallback)(newOptions => {
    onPopoverClose();
    onOptionsChange(newOptions);
  }, [onOptionsChange, onPopoverClose]);
  const onDivClick = (0, _react.useCallback)(e => {
    // Div to capture click events and stop propagation to
    // prevent clicking on the column header which triggers a sorting call.
    // The div needs to be here because EuiSelectable does not pass the event
    // into the onChange handler
    e.stopPropagation();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "gear",
      size: "s",
      "data-test-subj": `percentileSelectablePopover-iconButton`,
      title: iconButtonTitle,
      "aria-label": iconButtonTitle,
      onClick: onButtonClick
    }),
    panelPaddingSize: "s",
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: divStyle,
    onClick: onDivClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "percentileSelectablePopover-selectable",
    singleSelection: "always",
    options: options,
    onChange: onOptionsChangeAndClosePopover
  }, list => list)));
});