"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionErrorBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleActionErrorBadge = props => {
  const {
    totalErrors,
    showIcon = false
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: showIcon ? 'warning' : undefined,
    color: totalErrors ? 'danger' : 'hollow',
    "data-test-subj": "ruleActionErrorBadge"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, totalErrors));
};
exports.RuleActionErrorBadge = RuleActionErrorBadge;