"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsQuery = buildEsQuery;
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildEsQuery({
  timeRange,
  kuery,
  filters = [],
  queries = [],
  config = {}
}) {
  var _getTime, _getTime2;
  const timeFilter = timeRange && {
    query: {
      bool: {
        minimum_should_match: 1,
        should: [(_getTime = (0, _common.getTime)(undefined, timeRange, {
          fieldName: _ruleDataUtils.ALERT_TIME_RANGE
        })) === null || _getTime === void 0 ? void 0 : _getTime.query, (_getTime2 = (0, _common.getTime)(undefined, timeRange, {
          fieldName: _ruleDataUtils.TIMESTAMP
        })) === null || _getTime2 === void 0 ? void 0 : _getTime2.query]
      }
    },
    meta: {
      type: _esQuery.FILTERS.CUSTOM
    }
  };
  const filtersToUse = [...(timeFilter ? [timeFilter] : []), ...filters];
  const kueryFilter = kuery ? [{
    query: kuery,
    language: 'kuery'
  }] : [];
  const queryToUse = [...kueryFilter, ...queries];
  return (0, _esQuery.buildEsQuery)(undefined, queryToUse, filtersToUse, config);
}