"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleTypeIdsByFeatureId = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = require("react");
var _lodash = require("lodash");
var _constants = require("@kbn/response-ops-alerts-table/constants");
var _constants2 = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_OBJECT = {};

/**
 * Groups all rule type ids under their respective feature id
 */
const useRuleTypeIdsByFeatureId = ruleTypesIndex => (0, _react.useMemo)(() => {
  if (!(ruleTypesIndex !== null && ruleTypesIndex !== void 0 && ruleTypesIndex.size)) {
    return EMPTY_OBJECT;
  }
  const map = Array.from(ruleTypesIndex.entries()).reduce((types, [ruleTypeId, ruleType]) => {
    let producer = ruleType.producer;
    // Some o11y apps are listed under 'observability' to create a grouped filter
    if (_constants.observabilityFeatureIds.includes(producer)) {
      producer = _ruleDataUtils.AlertConsumers.OBSERVABILITY;
    }
    // Stack includes ML in this context
    if (_constants.stackFeatureIds.includes(producer)) {
      producer = _ruleDataUtils.AlertConsumers.STACK_ALERTS;
    }

    // Multi consumer rule type ids should be listed both in Observability and Stack alerts
    if (_constants2.MULTI_CONSUMER_RULE_TYPE_IDS.includes(ruleType.id)) {
      (types[_ruleDataUtils.AlertConsumers.OBSERVABILITY] = types[_ruleDataUtils.AlertConsumers.OBSERVABILITY] || new Set()).add(ruleTypeId);
      (types[_ruleDataUtils.AlertConsumers.STACK_ALERTS] = types[_ruleDataUtils.AlertConsumers.STACK_ALERTS] || new Set()).add(ruleTypeId);
    } else {
      (types[producer] = types[producer] || new Set()).add(ruleTypeId);
    }
    return types;
  }, {});
  return (0, _lodash.mapValues)(map, v => v ? [...v] : []);
}, [ruleTypesIndex]);
exports.useRuleTypeIdsByFeatureId = useRuleTypeIdsByFeatureId;