"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionTypeCompare = actionTypeCompare;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function actionTypeCompare(a, b, preconfiguredConnectors) {
  const aEnabled = getIsEnabledValue(a, preconfiguredConnectors);
  const bEnabled = getIsEnabledValue(b, preconfiguredConnectors);
  if (aEnabled === true && bEnabled === false) {
    return -1;
  }
  if (aEnabled === false && bEnabled === true) {
    return 1;
  }
  return a.name.localeCompare(b.name);
}
const getIsEnabledValue = (actionType, preconfiguredConnectors) => {
  let isEnabled = actionType.enabled;
  if (!actionType.enabledInConfig && preconfiguredConnectors && preconfiguredConnectors.length > 0) {
    isEnabled = preconfiguredConnectors.find(connector => connector.actionTypeId === actionType.id) !== undefined;
  }
  return isEnabled;
};