"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = exports.BREADCRUMB_SECTION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _text = require("../text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let BREADCRUMB_SECTION = exports.BREADCRUMB_SECTION = /*#__PURE__*/function (BREADCRUMB_SECTION) {
  BREADCRUMB_SECTION["HOME"] = "home";
  BREADCRUMB_SECTION["CLONE_TRANSFORM"] = "cloneTransform";
  BREADCRUMB_SECTION["CREATE_TRANSFORM"] = "createTransform";
  return BREADCRUMB_SECTION;
}({});
class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      home: [],
      cloneTransform: [],
      createTransform: []
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;

    // Home and sections
    this.breadcrumbs.home = [{
      text: _text.textService.breadcrumbs.home,
      href: '/'
    }];
    this.breadcrumbs.cloneTransform = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.cloneTransform
    }];
    this.breadcrumbs.createTransform = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.createTransform
    }];
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
const breadcrumbService = exports.breadcrumbService = new BreadcrumbService();