"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDetailsSummary = exports.StepDetailsSummary = /*#__PURE__*/_react.default.memo(props => {
  const {
    continuousModeDateField,
    createDataView,
    isContinuousModeEnabled,
    isRetentionPolicyEnabled,
    retentionPolicyDateField,
    retentionPolicyMaxAge,
    transformId,
    transformDescription,
    transformFrequency,
    transformSettingsMaxPageSearchSize,
    transformSettingsNumFailureRetries,
    destinationIndex,
    destinationIngestPipeline,
    touched,
    dataViewTimeField
  } = props;
  if (touched === false) {
    return null;
  }
  const destinationIndexHelpText = createDataView ? _i18n.i18n.translate('xpack.transform.stepDetailsSummary.createDataViewMessage', {
    defaultMessage: 'A Kibana data view will be created for this transform.'
  }) : '';
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDetailsSummary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.transformIdLabel', {
      defaultMessage: 'Transform ID'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, transformId)), transformDescription !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.transformDescriptionLabel', {
      defaultMessage: 'Transform description'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, transformDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: destinationIndexHelpText,
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.destinationIndexLabel', {
      defaultMessage: 'Destination index'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, destinationIndex)), createDataView && dataViewTimeField !== undefined && dataViewTimeField !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.dataViewTimeFieldLabel', {
      defaultMessage: 'Kibana data view time field'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, dataViewTimeField)), destinationIngestPipeline !== undefined && destinationIngestPipeline !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.destinationIngestPipelineLabel', {
      defaultMessage: 'Destination ingest pipeline'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, destinationIngestPipeline)), isContinuousModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.continuousModeDateFieldLabel', {
      defaultMessage: 'Continuous mode date field'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, continuousModeDateField)), isRetentionPolicyEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.retentionPolicyDateFieldLabel', {
      defaultMessage: 'Retention policy date field'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, retentionPolicyDateField)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.retentionPolicyMaxAgeLabel', {
      defaultMessage: 'Retention policy max age'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, retentionPolicyMaxAge))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "transformWizardAccordionAdvancedSettingsSummary",
    id: "transformWizardAccordionAdvancedSettingsSummary",
    buttonContent: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.advancedSettingsAccordionButtonContent', {
      defaultMessage: 'Advanced settings'
    }),
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsFrequencyLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.frequencyLabel', {
      defaultMessage: 'Frequency'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, transformFrequency)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsMaxPageSearchSizeLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.maxPageSearchSizeLabel', {
      defaultMessage: 'Maximum page search size'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, transformSettingsMaxPageSearchSize)), typeof transformSettingsNumFailureRetries === 'number' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsNumFailureRetriesLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.numFailureRetriesLabel', {
      defaultMessage: 'Number of retries'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, transformSettingsNumFailureRetries)) : null));
});