"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatePicker = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _mlDatePicker = require("@kbn/ml-date-picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatePicker = (defaults, dataView) => {
  const hasValidTimeField = (0, _react.useMemo)(() => dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView.timeFieldName]);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: hasValidTimeField,
    autoRefreshSelector: false
  });

  // The internal state of the date picker apply button.
  const [isDatePickerApplyEnabled, setDatePickerApplyEnabled] = (0, _react.useState)(defaults.isDatePickerApplyEnabled);

  // The time range selected via the date picker
  const [timeRange, setTimeRange] = (0, _react.useState)();

  // Set up subscriptions to date picker updates
  (0, _react.useEffect)(() => {
    const updateTimeRange = () => setTimeRange(timefilter.getTime());
    const timefilterUpdateSubscription = (0, _rxjs.merge)(timefilter.getAutoRefreshFetch$(), timefilter.getTimeUpdate$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(updateTimeRange);
    const timefilterEnabledSubscription = timefilter.getEnabledUpdated$().subscribe(updateTimeRange);
    return () => {
      timefilterUpdateSubscription.unsubscribe();
      timefilterEnabledSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Derive ms timestamps from timeRange updates.
  const timeRangeMs = (0, _react.useMemo)(() => {
    const timefilterActiveBounds = timefilter.getActiveBounds();
    if (timefilterActiveBounds !== undefined && timefilterActiveBounds.min !== undefined && timefilterActiveBounds.max !== undefined) {
      return {
        from: timefilterActiveBounds.min.valueOf(),
        to: timefilterActiveBounds.max.valueOf()
      };
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [timeRange]);
  return {
    actions: {
      setDatePickerApplyEnabled
    },
    state: {
      isDatePickerApplyEnabled,
      hasValidTimeField,
      timeRange,
      timeRangeMs
    }
  };
};
exports.useDatePicker = useDatePicker;