"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringValidator = void 0;
var _messages = require("./messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringValidator = (value, isOptional = true) => {
  if (typeof value !== 'string') {
    return [_messages.stringNotValidErrorMessage];
  }
  if (value.length === 0 && !isOptional) {
    return [_messages.requiredErrorMessage];
  }
  return [];
};
exports.stringValidator = stringValidator;