"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_LIST_COLUMN = void 0;
exports.isTransformListRowWithStats = isTransformListRowWithStats;
exports.missingTransformStats = missingTransformStats;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Used to pass on attribute names to table columns
let TRANSFORM_LIST_COLUMN = exports.TRANSFORM_LIST_COLUMN = /*#__PURE__*/function (TRANSFORM_LIST_COLUMN) {
  TRANSFORM_LIST_COLUMN["DESCRIPTION"] = "config.description";
  TRANSFORM_LIST_COLUMN["ID"] = "id";
  return TRANSFORM_LIST_COLUMN;
}({});
function isTransformListRowWithStats(arg) {
  return arg.stats !== undefined;
}
function missingTransformStats(items) {
  return items.some(i => !isTransformListRowWithStats(i));
}

// The single Action type is not exported as is
// from EUI so we use that code to get the single
// Action type from the array of actions.