"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterQuery = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esMatchQuerySchema = _zod.z.object({
  match: _zod.z.record(_zod.z.string(), _zod.z.object({
    query: _zod.z.string(),
    operator: _zod.z.string(),
    zero_terms_query: _zod.z.string()
  }))
});
const esQueryStringQuerySchema = _zod.z.object({
  query_string: _zod.z.object({
    query: _zod.z.string(),
    analyze_wildcard: _zod.z.boolean()
  })
});
const esTermQuerySchema = _zod.z.object({
  term: _zod.z.record(_zod.z.string(), _zod.z.string())
});
const esBoolQuerySchema = _zod.z.object({
  bool: _zod.z.object({
    filter: _zod.z.array(_zod.z.object({})),
    must: _zod.z.array(_zod.z.object({})),
    must_not: _zod.z.array(_zod.z.object({})),
    should: _zod.z.array(_zod.z.object({}))
  })
});
const esRangeQuerySchema = _zod.z.object({
  range: _zod.z.record(_zod.z.string(), _zod.z.object({
    gte: _zod.z.number(),
    lte: _zod.z.number(),
    format: _zod.z.string()
  }))
});
const jsonObjectSchema = _zod.z.record(_zod.z.string(), _zod.z.any());
const esQuerySchema = _zod.z.union([esRangeQuerySchema, esQueryStringQuerySchema, esMatchQuerySchema, esTermQuerySchema, esBoolQuerySchema, jsonObjectSchema]);
const filterQuery = exports.filterQuery = _zod.z.union([_zod.z.string(), _zod.z.undefined(), esQuerySchema]);