"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsInspectStatusRuleRoute = void 0;
var _synthetics_monitor_status = require("@kbn/response-ops-rule-params/synthetics_monitor_status");
var _status_rule_executor = require("../../alert_rules/status_rule/status_rule_executor");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsInspectStatusRuleRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.INSPECT_STATUS_RULE,
  validate: {
    body: _synthetics_monitor_status.syntheticsMonitorStatusRuleParamsSchema
  },
  handler: async ({
    request,
    server,
    syntheticsMonitorClient,
    savedObjectsClient,
    spaceId,
    context,
    syntheticsEsClient
  }) => {
    const {
      uiSettings,
      elasticsearch
    } = await context.core;
    const {
      client: esClient
    } = elasticsearch;
    const ruleParams = request.body;
    const services = {
      scopedClusterClient: esClient,
      savedObjectsClient,
      uiSettingsClient: uiSettings.client
    };
    const statusRule = new _status_rule_executor.StatusRuleExecutor(syntheticsEsClient, server, syntheticsMonitorClient, {
      spaceId,
      services,
      params: ruleParams,
      state: {},
      previousStartedAt: new Date(),
      rule: {
        name: 'Inspect Status Rule',
        id: 'inspect-status-rule'
      },
      logger: server.logger,
      executionId: 'inspect-status-rule',
      startedAt: new Date(),
      isServerless: false,
      startedAtOverridden: false,
      flappingSettings: {},
      getTimeRange: {}
    });
    return await statusRule.getRuleThresholdOverview();
  }
});
exports.syntheticsInspectStatusRuleRoute = syntheticsInspectStatusRuleRoute;