"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAPIKeySyntheticsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _add_monitor_project = require("./project_monitor/add_monitor_project");
var _get_api_key = require("../../synthetics_service/get_api_key");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAPIKeySyntheticsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_PROJECT_APIKEY,
  validate: {
    query: _configSchema.schema.object({
      spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      accessToElasticManagedLocations: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  handler: async ({
    request,
    server,
    response
  }) => {
    const {
      accessToElasticManagedLocations,
      spaces
    } = request.query;
    if (accessToElasticManagedLocations) {
      var _Boolean, _server$coreStart;
      const elasticManagedLocationsEnabled = (_Boolean = Boolean((await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
        capabilityPath: 'uptime.*'
      }))).uptime.elasticManagedLocationsEnabled)) !== null && _Boolean !== void 0 ? _Boolean : true;
      if (!elasticManagedLocationsEnabled) {
        return response.customError({
          body: {
            message: _add_monitor_project.ELASTIC_MANAGED_LOCATIONS_DISABLED
          },
          statusCode: 403
        });
      }
    }
    const apiKey = await (0, _get_api_key.generateProjectAPIKey)({
      request,
      server,
      accessToElasticManagedLocations,
      spaces
    });
    return {
      apiKey
    };
  }
});
exports.getAPIKeySyntheticsRoute = getAPIKeySyntheticsRoute;