"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api_service = require("../api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaService {
  init({
    coreSetup,
    coreStart,
    startPlugins,
    isDev,
    isServerless
  }) {
    this.coreSetup = coreSetup;
    this.coreStart = coreStart;
    this.startPlugins = startPlugins;
    this.theme = coreStart.uiSettings.get$('theme:darkMode');
    _api_service.apiService.http = coreStart.http;
    this.isDev = isDev;
    this.isServerless = isServerless;
  }
  get toasts() {
    return this.coreStart.notifications.toasts;
  }
  constructor() {
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "coreSetup", void 0);
    (0, _defineProperty2.default)(this, "theme", void 0);
    (0, _defineProperty2.default)(this, "setupPlugins", void 0);
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    (0, _defineProperty2.default)(this, "appMountParameters", void 0);
    (0, _defineProperty2.default)(this, "startPlugins", void 0);
  }
  static getInstance() {
    if (!KibanaService.instance) {
      KibanaService.instance = new KibanaService();
    }
    return KibanaService.instance;
  }
}
(0, _defineProperty2.default)(KibanaService, "instance", void 0);
const kibanaService = exports.kibanaService = KibanaService.getInstance();