"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _status_badge = require("../common/monitor_test_result/status_badge");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _monitor_status = require("../common/components/monitor_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDetailsStatus = () => {
  var _currentStep$syntheti;
  const {
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  });
  if (currentStep !== null && currentStep !== void 0 && (_currentStep$syntheti = currentStep.synthetics.step) !== null && _currentStep$syntheti !== void 0 && _currentStep$syntheti.status) {
    var _currentStep$syntheti2;
    content = /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
      status: (0, _status_badge.parseBadgeStatus)((_currentStep$syntheti2 = currentStep.synthetics.step) === null || _currentStep$syntheti2 === void 0 ? void 0 : _currentStep$syntheti2.status)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    align: "left",
    compressed: false,
    listItems: [{
      title: _monitor_status.STATUS_LABEL,
      description: content
    }]
  });
};
exports.StepDetailsStatus = StepDetailsStatus;