"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorFilters = void 0;
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _use_url_params = require("../../../hooks/use_url_params");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _overview_status = require("../../../state/overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFiltersForField = ({
  field,
  values,
  useLogicalAnd = false
}) => {
  if (!values || !values.length) return [];
  const valueArray = getValues(values);
  return useLogicalAnd ? valueArray.map(value => ({
    field,
    values: [value]
  })) : [{
    field,
    values: valueArray
  }];
};
const useMonitorFilters = ({
  forAlerts
}) => {
  var _overviewStatus$allId;
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    locations,
    monitorTypes,
    tags,
    projects,
    schedules,
    useLogicalAndFor
  } = (0, _use_url_params.useGetUrlParams)();
  const {
    status: overviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const allIds = (_overviewStatus$allId = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allIds) !== null && _overviewStatus$allId !== void 0 ? _overviewStatus$allId : [];

  // since schedule isn't available in heartbeat data, in that case we rely on monitor.id
  // We need to rely on monitor.id also for locations, because each heartbeat data only contains one location
  if (!(0, _lodash.isEmpty)(schedules) || !(0, _lodash.isEmpty)(locations) && useLogicalAndFor !== null && useLogicalAndFor !== void 0 && useLogicalAndFor.includes('locations')) {
    // If allIds is empty we return an array with a random id just to not get any result, there's probably a better solution
    return [{
      field: 'monitor.id',
      values: allIds.length ? allIds : [(0, _lodash.uniqueId)()]
    }];
  }
  return [...(projects !== null && projects !== void 0 && projects.length ? [{
    field: 'monitor.project.id',
    values: getValues(projects)
  }] : []), ...(monitorTypes !== null && monitorTypes !== void 0 && monitorTypes.length ? [{
    field: 'monitor.type',
    values: getValues(monitorTypes)
  }] : []), ...createFiltersForField({
    useLogicalAnd: useLogicalAndFor === null || useLogicalAndFor === void 0 ? void 0 : useLogicalAndFor.includes('tags'),
    field: 'tags',
    values: tags
  }), ...(locations !== null && locations !== void 0 && locations.length ? [{
    field: 'observer.geo.name',
    values: getValues(locations)
  }] : []), ...(space ? [{
    field: forAlerts ? 'kibana.space_ids' : 'meta.space_id',
    values: [space.id]
  }] : [])];
};
exports.useMonitorFilters = useMonitorFilters;
const getValues = values => {
  return Array.isArray(values) ? values : [values];
};