"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLastRun = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_monitor_latest_ping = require("./hooks/use_monitor_latest_ping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDetailsLastRun = () => {
  const {
    latestPing,
    loading: pingsLoading
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  let description = latestPing ? (0, _moment.default)(latestPing['@timestamp']).fromNow() : '--';
  if (!latestPing && pingsLoading) {
    description = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: LAST_RUN_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: (0, _moment.default)(latestPing === null || latestPing === void 0 ? void 0 : latestPing['@timestamp']).format('LLL'),
        position: "bottom"
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0
      }, description))
    }]
  });
};
exports.MonitorDetailsLastRun = MonitorDetailsLastRun;
const LAST_RUN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorLastRun.lastRunLabel', {
  defaultMessage: 'Last run'
});