"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = ErrorCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Use this component when displaying fetch-related errors.
 */
function ErrorCallout(error) {
  var _error$body, _error$body2, _error$body3;
  const listItems = [];
  if ((_error$body = error.body) !== null && _error$body !== void 0 && _error$body.statusCode) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.monitorDetailFlyout.fetchError.statusCode', {
        defaultMessage: 'Status:'
      }),
      description: error.body.statusCode
    });
  }
  if ((_error$body2 = error.body) !== null && _error$body2 !== void 0 && _error$body2.error) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.monitorDetailFlyout.fetchError.error', {
        defaultMessage: 'Error:'
      }),
      description: error.body.error
    });
  }
  if ((_error$body3 = error.body) !== null && _error$body3 !== void 0 && _error$body3.message) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.monitorDetailFlyout.fetchError.messageTitle', {
        defaultMessage: 'Message:'
      }),
      description: error.body.message
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.synthetics.monitorDetail.errorTitle', {
      defaultMessage: 'Error fetching monitor details'
    }),
    iconType: "alert"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.synthetics.monitorDetailFlyout.fetchError.description', {
    defaultMessage: 'Unable to fetch monitor details'
  })), listItems.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "responsiveColumn",
    listItems: listItems
  }));
}