"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settings = exports.VALID_UNTIL_COL = exports.TOO_OLD = exports.STATUS_COL = exports.SPACE_STR = exports.SEARCH_CERTS = exports.REFRESH_CERT = exports.OK = exports.NO_CERTS_AVAILABLE = exports.MONITORS_COL = exports.LOADING_CERTIFICATES = exports.ISSUED_BY_COL = exports.FINGERPRINTS_COL = exports.EXPIRES_SOON = exports.EXPIRES = exports.EXPIRED = exports.DAYS = exports.COPY_FINGERPRINT = exports.COMMON_NAME_COL = exports.BLANK_STR = exports.AGE_COL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OK = exports.OK = _i18n.i18n.translate('xpack.synthetics.certs.ok', {
  defaultMessage: 'OK'
});
const EXPIRED = exports.EXPIRED = _i18n.i18n.translate('xpack.synthetics.certs.expired', {
  defaultMessage: 'Expired'
});
const EXPIRES_SOON = exports.EXPIRES_SOON = _i18n.i18n.translate('xpack.synthetics.certs.expireSoon', {
  defaultMessage: 'Expires soon'
});
const EXPIRES = exports.EXPIRES = _i18n.i18n.translate('xpack.synthetics.certs.expires', {
  defaultMessage: 'Expires'
});
const SEARCH_CERTS = exports.SEARCH_CERTS = _i18n.i18n.translate('xpack.synthetics.certs.searchCerts', {
  defaultMessage: 'Search certificates'
});
const STATUS_COL = exports.STATUS_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.status', {
  defaultMessage: 'Status'
});
const TOO_OLD = exports.TOO_OLD = _i18n.i18n.translate('xpack.synthetics.certs.list.status.old', {
  defaultMessage: 'Too old'
});
const COMMON_NAME_COL = exports.COMMON_NAME_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.commonName', {
  defaultMessage: 'Common name'
});
const MONITORS_COL = exports.MONITORS_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.monitors', {
  defaultMessage: 'Monitors'
});
const ISSUED_BY_COL = exports.ISSUED_BY_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.issuedBy', {
  defaultMessage: 'Issued by'
});
const VALID_UNTIL_COL = exports.VALID_UNTIL_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.validUntil', {
  defaultMessage: 'Valid until'
});
const AGE_COL = exports.AGE_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.ageCol', {
  defaultMessage: 'Age'
});
const DAYS = exports.DAYS = _i18n.i18n.translate('xpack.synthetics.certs.list.days', {
  defaultMessage: 'days'
});
const FINGERPRINTS_COL = exports.FINGERPRINTS_COL = _i18n.i18n.translate('xpack.synthetics.certs.list.expirationDate', {
  defaultMessage: 'Fingerprints'
});
const COPY_FINGERPRINT = exports.COPY_FINGERPRINT = _i18n.i18n.translate('xpack.synthetics.certs.list.copyFingerprint', {
  defaultMessage: 'Click to copy fingerprint value'
});
const NO_CERTS_AVAILABLE = exports.NO_CERTS_AVAILABLE = _i18n.i18n.translate('xpack.synthetics.certs.list.noCerts', {
  defaultMessage: 'No Certificates found.'
});
const LOADING_CERTIFICATES = exports.LOADING_CERTIFICATES = _i18n.i18n.translate('xpack.synthetics.certificates.loading', {
  defaultMessage: 'Loading certificates ...'
});
const REFRESH_CERT = exports.REFRESH_CERT = _i18n.i18n.translate('xpack.synthetics.certificates.refresh', {
  defaultMessage: 'Refresh'
});
const settings = exports.settings = {
  breadcrumbText: _i18n.i18n.translate('xpack.synthetics.settingsBreadcrumbText', {
    defaultMessage: 'Settings'
  }),
  editNoticeTitle: _i18n.i18n.translate('xpack.synthetics.settings.cannotEditTitle', {
    defaultMessage: 'You do not have permission to edit settings.'
  }),
  editNoticeText: _i18n.i18n.translate('xpack.synthetics.settings.cannotEditText', {
    defaultMessage: "Your user currently has 'Read' permissions for the Uptime app. Enable a permissions-level of 'All' to edit these settings."
  }),
  mustBeNumber: _i18n.i18n.translate('xpack.synthetics.settings.blankNumberField.error', {
    defaultMessage: 'Must be a number.'
  })
};
const BLANK_STR = exports.BLANK_STR = _i18n.i18n.translate('xpack.synthetics.settings.blank.error', {
  defaultMessage: 'May not be blank.'
});
const SPACE_STR = exports.SPACE_STR = _i18n.i18n.translate('xpack.synthetics.settings.noSpace.error', {
  defaultMessage: 'Index names must not contain space'
});