"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatKibanaNamespace = void 0;
var _common = require("@kbn/fleet-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* Formats kibana space id into a valid Fleet-compliant data-stream namespace */

const formatKibanaNamespace = spaceId => {
  const namespaceRegExp = new RegExp(_common.INVALID_NAMESPACE_CHARACTERS, 'g');
  return spaceId.replace(namespaceRegExp, '_');
};
exports.formatKibanaNamespace = formatKibanaNamespace;