"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "repositoryClient", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core, pluginSetup) {
    this.repositoryClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core);
    return {};
  }
  start(core, pluginsStart) {
    return {
      streamsRepositoryClient: this.repositoryClient,
      status$: createStreamsStatusObservable(core, this.repositoryClient, this.logger),
      config$: (0, _rxjs.of)(this.config)
    };
  }
  stop() {}
}
exports.Plugin = Plugin;
const ENABLED_STATUS = {
  status: 'enabled'
};
const DISABLED_STATUS = {
  status: 'disabled'
};
const UNKNOWN_STATUS = {
  status: 'unknown'
};
const createStreamsStatusObservable = (0, _lodash.once)((core, repositoryClient, logger) => {
  var _application$capabili, _application$capabili2;
  const {
    application,
    uiSettings
  } = core;
  const hasCapabilities = (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.streams) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show;
  const isUIEnabled = uiSettings.get(_managementSettingsIds.OBSERVABILITY_ENABLE_STREAMS_UI);
  if (!hasCapabilities) {
    return (0, _rxjs.of)(DISABLED_STATUS);
  }
  if (isUIEnabled) {
    return (0, _rxjs.of)(ENABLED_STATUS);
  }
  return (0, _rxjs.from)(repositoryClient.fetch('GET /api/streams/_status', {
    signal: new AbortController().signal
  }).then(response => response.enabled ? ENABLED_STATUS : DISABLED_STATUS, error => {
    logger.error(error);
    return UNKNOWN_STATUS;
  })).pipe((0, _rxjs.startWith)(UNKNOWN_STATUS), (0, _rxjs.shareReplay)(1));
});