"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventsTable = SignificantEventsTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _change_point = require("./change_point");
var _change_point_summary = require("./change_point_summary");
var _significant_events_histogram = require("./significant_events_histogram");
var _discover_helpers = require("./utils/discover_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WithLoadingSpinner({
  onClick,
  ...props
}) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({}, props, {
    isLoading: isLoading,
    isDisabled: isLoading,
    onClick: event => {
      setIsLoading(true);
      Promise.resolve(onClick === null || onClick === void 0 ? void 0 : onClick(event)).finally(() => {
        setIsLoading(false);
      });
    }
  }));
}
function SignificantEventsTable({
  definition,
  response,
  onDeleteClick,
  onEditClick,
  xFormatter
}) {
  const {
    dependencies: {
      start: {
        discover
      }
    }
  } = (0, _use_kibana.useKibana)();
  const items = (0, _react.useMemo)(() => {
    var _response$value;
    return (_response$value = response.value) !== null && _response$value !== void 0 ? _response$value : [];
  }, [response.value]);
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.titleColumnTitle', {
      defaultMessage: 'Title'
    }),
    render: (_, record) => {
      var _discover$locator;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl((0, _discover_helpers.buildDiscoverParams)(record, definition))
      }, record.query.title);
    }
  }, {
    field: 'change',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.changeColumnTitle', {
      defaultMessage: 'Change'
    }),
    render: (_, item) => {
      const change = (0, _change_point.formatChangePoint)(item);
      return /*#__PURE__*/_react.default.createElement(_change_point_summary.ChangePointSummary, {
        change: change,
        xFormatter: xFormatter
      });
    }
  }, {
    field: 'occurrences',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.occurrencesColumnTitle', {
      defaultMessage: 'Occurrences'
    }),
    render: (_, item) => {
      const change = (0, _change_point.formatChangePoint)(item);
      return /*#__PURE__*/_react.default.createElement(_significant_events_histogram.SignificantEventsHistogramChart, {
        id: item.query.id,
        occurrences: item.occurrences,
        change: change,
        xFormatter: xFormatter
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.streams.significantEventsTable.editQueryActionTitle', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.streams.significantEventsTable.editQueryActionDescription', {
        defaultMessage: 'Edit query'
      }),
      render: item => {
        return /*#__PURE__*/_react.default.createElement(WithLoadingSpinner, {
          iconType: "pencil",
          onClick: () => {
            return onEditClick === null || onEditClick === void 0 ? void 0 : onEditClick(item);
          }
        });
      }
    }, {
      name: _i18n.i18n.translate('xpack.streams.significantEventsTable.removeQueryActionTitle', {
        defaultMessage: 'Remove'
      }),
      description: _i18n.i18n.translate('xpack.streams.significantEventsTable.removeQueryActionDescription', {
        defaultMessage: 'Remove query from stream'
      }),
      render: item => {
        return /*#__PURE__*/_react.default.createElement(WithLoadingSpinner, {
          iconType: "trash",
          onClick: () => {
            return onDeleteClick === null || onDeleteClick === void 0 ? void 0 : onDeleteClick(item);
          }
        });
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.streams.significantEventsTable.tableCaption', {
      defaultMessage: 'Significant events'
    }),
    compressed: true,
    items: items,
    rowHeader: "title",
    columns: columns,
    loading: response.loading,
    tableLayout: "auto",
    itemId: "id"
  });
}