"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _streams_chart_tooltip = require("../streams_chart_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SparkPlot({
  id,
  name,
  type,
  timeseries,
  annotations,
  compressed,
  xFormatter: givenXFormatter
}) {
  var _timeseries$, _timeseries;
  const {
    dependencies: {
      start: {
        charts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const defaultTheme = charts.theme.chartsDefaultBaseTheme;
  const sparkplotChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    chartPaddings: {
      top: 12,
      bottom: 12
    },
    lineSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    background: {
      color: `rgba(0,0,0,0)`
    },
    axes: {
      gridLine: {
        horizontal: {
          opacity: 1,
          stroke: `rgba(0,0,0,1)`
        }
      }
    }
  };
  const min = (_timeseries$ = timeseries[0]) === null || _timeseries$ === void 0 ? void 0 : _timeseries$.x;
  const max = (_timeseries = timeseries[timeseries.length - 1]) === null || _timeseries === void 0 ? void 0 : _timeseries.x;
  const defaultXFormatter = (0, _react.useMemo)(() => {
    return (0, _charts.niceTimeFormatter)([min, max]);
  }, [min, max]);
  const xFormatter = givenXFormatter || defaultXFormatter;
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: compressed ? 64 : 48
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: data => {
      return xFormatter(data.value);
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y_axis",
    position: "left",
    hide: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [sparkplotChartTheme, baseTheme],
    baseTheme: defaultTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), type && type === 'bar' ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: id,
    name: name || id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: timeseries,
    enableHistogramMode: true
  }) : /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: id,
    name: name || id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    data: timeseries,
    curve: _charts.CurveType.CURVE_MONOTONE_X
  }), annotations === null || annotations === void 0 ? void 0 : annotations.map(annotation => {
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      key: annotation.id,
      id: annotation.id,
      dataValues: [{
        dataValue: annotation.x
      }],
      domainType: _charts.AnnotationDomainType.XDomain,
      marker: annotation.icon,
      markerPosition: _charts.Position.Bottom,
      style: {
        line: {
          strokeWidth: 2,
          stroke: annotation.color
        }
      },
      customTooltip: () => {
        return /*#__PURE__*/_react.default.createElement(_streams_chart_tooltip.StreamsChartTooltip, {
          label: annotation.label,
          color: annotation.color
        });
      }
    });
  }));
}