"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamEnrichmentSelector = exports.useStreamEnrichmentEvents = exports.useSimulatorSelector = exports.useSimulatorRef = exports.useGetStreamEnrichmentState = exports.StreamEnrichmentContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@xstate5/react");
var _xstateUtils = require("@kbn/xstate-utils");
var _stream_enrichment_state_machine = require("./stream_enrichment_state_machine");
var _utils = require("../../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const consoleInspector = (0, _xstateUtils.createConsoleInspector)();
const StreamEnrichmentContext = (0, _react2.createActorContext)(_stream_enrichment_state_machine.streamEnrichmentMachine);
const useStreamEnrichmentSelector = exports.useStreamEnrichmentSelector = StreamEnrichmentContext.useSelector;
const useGetStreamEnrichmentState = () => {
  const service = StreamEnrichmentContext.useActorRef();
  return (0, _react.useCallback)(() => service.getSnapshot(), [service]);
};
exports.useGetStreamEnrichmentState = useGetStreamEnrichmentState;
const useStreamEnrichmentEvents = () => {
  const service = StreamEnrichmentContext.useActorRef();
  return (0, _react.useMemo)(() => ({
    addProcessor: processor => {
      service.send({
        type: 'processors.add',
        processor
      });
    },
    reorderProcessors: processorsRefs => {
      service.send({
        type: 'processors.reorder',
        processorsRefs
      });
    },
    resetChanges: () => {
      service.send({
        type: 'stream.reset'
      });
    },
    saveChanges: () => {
      service.send({
        type: 'stream.update'
      });
    },
    refreshSimulation: () => {
      service.send({
        type: 'simulation.refresh'
      });
    },
    viewSimulationPreviewData: () => {
      service.send({
        type: 'simulation.viewDataPreview'
      });
    },
    viewSimulationDetectedFields: () => {
      service.send({
        type: 'simulation.viewDetectedFields'
      });
    },
    changePreviewDocsFilter: filter => {
      service.send({
        type: 'simulation.changePreviewDocsFilter',
        filter
      });
    },
    mapField: field => {
      service.send({
        type: 'simulation.fields.map',
        field: field
      });
    },
    unmapField: fieldName => {
      service.send({
        type: 'simulation.fields.unmap',
        fieldName
      });
    },
    openDataSourcesManagement: () => {
      service.send({
        type: 'dataSources.openManagement'
      });
    },
    closeDataSourcesManagement: () => {
      service.send({
        type: 'dataSources.closeManagement'
      });
    },
    addDataSource: dataSource => {
      service.send({
        type: 'dataSources.add',
        dataSource
      });
    },
    setExplicitlyEnabledPreviewColumns: columns => {
      service.send({
        type: 'previewColumns.updateExplicitlyEnabledColumns',
        columns: columns.filter(col => col.trim() !== '')
      });
    },
    setExplicitlyDisabledPreviewColumns: columns => {
      service.send({
        type: 'previewColumns.updateExplicitlyDisabledColumns',
        columns: columns.filter(col => col.trim() !== '')
      });
    },
    setPreviewColumnsOrder: columns => {
      service.send({
        type: 'previewColumns.order',
        columns: columns.filter(col => col.trim() !== '')
      });
    },
    setPreviewColumnsSorting: sorting => {
      service.send({
        type: 'previewColumns.setSorting',
        sorting
      });
    }
  }), [service]);
};
exports.useStreamEnrichmentEvents = useStreamEnrichmentEvents;
const StreamEnrichmentContextProvider = ({
  children,
  definition,
  ...deps
}) => {
  return /*#__PURE__*/_react.default.createElement(StreamEnrichmentContext.Provider, {
    logic: _stream_enrichment_state_machine.streamEnrichmentMachine.provide((0, _stream_enrichment_state_machine.createStreamEnrichmentMachineImplementations)(deps)),
    options: {
      id: 'streamEnrichment',
      inspect: consoleInspector,
      input: {
        definition
      }
    }
  }, /*#__PURE__*/_react.default.createElement(StreamEnrichmentCleanupOnUnmount, null), /*#__PURE__*/_react.default.createElement(ListenForDefinitionChanges, {
    definition: definition
  }, children));
};

/* Grok resources are not directly modeled by Xstate (they are not first class machines or actors etc) */
exports.StreamEnrichmentContextProvider = StreamEnrichmentContextProvider;
const StreamEnrichmentCleanupOnUnmount = () => {
  const service = StreamEnrichmentContext.useActorRef();
  (0, _react.useEffect)(() => {
    return () => {
      const context = service.getSnapshot().context;
      context.processorsRefs.forEach(procRef => {
        const procContext = procRef.getSnapshot().context;
        if ((0, _utils.isGrokProcessor)(procContext.processor)) {
          var _procContext$resource, _procContext$resource2;
          const draftGrokExpressions = (_procContext$resource = (_procContext$resource2 = procContext.resources) === null || _procContext$resource2 === void 0 ? void 0 : _procContext$resource2.grokExpressions) !== null && _procContext$resource !== void 0 ? _procContext$resource : [];
          draftGrokExpressions.forEach(expression => {
            expression.destroy();
          });
        }
      });
    };
  }, [service]);
  return null;
};
const ListenForDefinitionChanges = ({
  children,
  definition
}) => {
  const service = StreamEnrichmentContext.useActorRef();
  (0, _react.useEffect)(() => {
    service.send({
      type: 'stream.received',
      definition
    });
  }, [definition, service]);
  return children;
};
const useSimulatorRef = () => {
  return useStreamEnrichmentSelector(state => state.context.simulatorRef);
};
exports.useSimulatorRef = useSimulatorRef;
const useSimulatorSelector = selector => {
  const simulationRef = useSimulatorRef();
  if (!simulationRef) {
    throw new Error('useSimulatorSelector must be used within a StreamEnrichmentContextProvider');
  }
  return (0, _react2.useSelector)(simulationRef, selector);
};
exports.useSimulatorSelector = useSimulatorSelector;