"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokPatternsEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _grokUi = require("@kbn/grok-ui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _stream_enrichment_state_machine = require("../../state_management/stream_enrichment_state_machine");
var _sortable_list = require("../../sortable_list");
var _use_ai_features = require("./use_ai_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GrokPatternAISuggestions = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./grok_pattern_suggestion'))).then(mod => ({
  default: mod.GrokPatternAISuggestions
})));
const GrokPatternsEditor = () => {
  const {
    formState: {
      errors
    },
    register,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(machineState => machineState.context.grokCollection);
  const {
    fields,
    append,
    remove,
    move
  } = (0, _reactHookForm.useFieldArray)({
    name: 'patterns'
  });
  const fieldsWithError = fields.map((field, id) => {
    var _errors$patterns, _errors$patterns$id;
    return {
      draftGrokExpression: field,
      error: (_errors$patterns = errors.patterns) === null || _errors$patterns === void 0 ? void 0 : (_errors$patterns$id = _errors$patterns[id]) === null || _errors$patterns$id === void 0 ? void 0 : _errors$patterns$id.value
    };
  });
  const handlerPatternDrag = ({
    source,
    destination
  }) => {
    if (source && destination) {
      move(source.index, destination.index);
    }
  };
  const handleAddPattern = () => {
    append(new _grokUi.DraftGrokExpression(grokCollection, ''));
  };
  const getRemovePatternHandler = id => fields.length > 1 ? () => remove(id) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditorLabel', {
      defaultMessage: 'Grok patterns'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_sortable_list.SortableList, {
    onDragItem: handlerPatternDrag
  }, fieldsWithError.map((field, idx) => /*#__PURE__*/_react.default.createElement(DraggablePatternInput, {
    key: field.draftGrokExpression.id,
    field: field,
    idx: idx,
    onRemove: getRemovePatternHandler(idx),
    inputProps: register(`patterns.${idx}.value`, {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditorRequiredError', {
        defaultMessage: 'A pattern is required.'
      })
    }),
    grokCollection: grokCollection,
    setValue: setValue
  }))))), aiFeatures ? /*#__PURE__*/_react.default.createElement(GrokPatternAISuggestions, {
    aiFeatures: aiFeatures,
    grokCollection: grokCollection,
    setValue: setValue,
    onAddPattern: handleAddPattern
  }) : /*#__PURE__*/_react.default.createElement(AddPatternButton, {
    onClick: handleAddPattern
  }));
};
exports.GrokPatternsEditor = GrokPatternsEditor;
const AddPatternButton = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "streamsAppGrokPatternsEditorAddPatternButton",
    flush: "left",
    size: "s"
  }, props), _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.addPattern', {
    defaultMessage: 'Add pattern'
  }));
};
const DraggablePatternInput = ({
  field,
  idx,
  inputProps,
  onRemove,
  grokCollection,
  setValue
}) => {
  const {
    error,
    draftGrokExpression
  } = field;
  const isInvalid = Boolean(error);
  const expression = (0, _useObservable.default)(draftGrokExpression.getExpression$());
  (0, _useDebounce.default)(() => {
    setValue(`patterns.${idx}.value`, field.draftGrokExpression);
  }, 300, [expression]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    index: idx,
    spacing: "m",
    draggableId: draftGrokExpression.id,
    hasInteractiveChildren: true,
    customDragHandle: true,
    css: {
      paddingLeft: 0,
      paddingRight: 0
    }
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: error === null || error === void 0 ? void 0 : error.message
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "s"
  }, provided.dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.dragHandleLabel', {
      defaultMessage: 'Drag Handle'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_grokUi.Expression, {
    draftGrokExpression: field.draftGrokExpression,
    grokCollection: grokCollection,
    dataTestSubj: "streamsAppPatternExpression"
  })), onRemove && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppDraggablePatternInputButton",
    iconType: "minusInCircle",
    color: "danger",
    onClick: () => onRemove(idx),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.removePattern', {
      defaultMessage: 'Remove grok pattern'
    })
  }))));
};