"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renameProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _condition = require("../../../../../../util/condition");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'rename',
  field: '',
  target_field: '',
  ignore_missing: false,
  override: false,
  if: _condition.ALWAYS_CONDITION,
  ignore_failure: false
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameFieldHelpText', {
    defaultMessage: 'The field to be renamed.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'target_field',
  type: 'string',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameTargetFieldHelpText",
    defaultMessage: "The new name of the field."
  })
}, {
  field: 'override',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameOverrideLabel', {
    defaultMessage: 'Override'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameOverrideHelpText",
    defaultMessage: "If true, the processor will update pre-existing non-null-valued fields. When set to false, such fields will not be touched."
  })
}];
const renameProcessorConfig = exports.renameProcessorConfig = {
  type: 'rename',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameInputDisplay', {
    defaultMessage: 'Rename'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameHelpText",
      defaultMessage: "{renameLink} If the field doesn\u2019t exist or the new name is already used, an exception will be thrown.",
      values: {
        renameLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsRenameLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.rename
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.renameLinkLabel', {
          defaultMessage: 'Renames an existing field.'
        }))
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('rename', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('rename', defaultFormState),
  fieldConfigurations,
  fieldOptions
};