"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.types = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createFactory(type, defaults) {
  return overrides => {
    return {
      ...defaults,
      ...overrides,
      type
    };
  };
}
const types = exports.types = {
  keyword: createFactory('keyword', {
    ignore_above: 1024
  }),
  match_only_text: createFactory('match_only_text'),
  text: createFactory('text'),
  double: createFactory('double'),
  long: createFactory('long'),
  boolean: createFactory('boolean'),
  date: createFactory('date', {
    format: 'strict_date_optional_time'
  }),
  byte: createFactory('byte'),
  float: createFactory('float'),
  object: createFactory('object')
};