"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TinesWebhooksApiResponseSchema = exports.TinesWebhookApiResponseSchema = exports.TinesStoriesApiResponseSchema = exports.TinesRunApiResponseSchema = exports.TinesBaseApiResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schema = require("../../../common/tines/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Tines response base schema
const TinesBaseApiResponseSchema = exports.TinesBaseApiResponseSchema = _configSchema.schema.object({
  meta: _configSchema.schema.object({
    pages: _configSchema.schema.number()
  }, {
    unknowns: 'ignore'
  })
}, {
  unknowns: 'ignore'
});

// Stories action schema
const TinesStoriesApiResponseSchema = exports.TinesStoriesApiResponseSchema = TinesBaseApiResponseSchema.extends({
  stories: _configSchema.schema.arrayOf(_schema.TinesStoryObjectSchema.extends({}, {
    unknowns: 'ignore'
  }))
}, {
  unknowns: 'ignore'
});

// Single Webhook action schema
const TinesWebhookApiResponseSchema = exports.TinesWebhookApiResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.number(),
  name: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  story_id: _configSchema.schema.number(),
  options: _configSchema.schema.object({
    path: _configSchema.schema.maybe(_configSchema.schema.string()),
    secret: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'ignore'
  })
}, {
  unknowns: 'ignore'
});

// Webhooks action schema
const TinesWebhooksApiResponseSchema = exports.TinesWebhooksApiResponseSchema = TinesBaseApiResponseSchema.extends({
  agents: _configSchema.schema.arrayOf(TinesWebhookApiResponseSchema)
}, {
  unknowns: 'ignore'
});
const TinesRunApiResponseSchema = exports.TinesRunApiResponseSchema = _configSchema.schema.object({}, {
  unknowns: 'ignore'
});