"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _credentials = require("./credentials");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServiceNowConnectorFieldsNoApp = ({
  isEdit,
  readOnly
}) => {
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.isOAuth']
  });
  const {
    isOAuth = false
  } = config !== null && config !== void 0 ? config : {};
  return /*#__PURE__*/_react.default.createElement(_credentials.Credentials, {
    readOnly: readOnly,
    isLoading: false,
    isOAuth: isOAuth
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = ServiceNowConnectorFieldsNoApp;
module.exports = exports.default;