"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionViewTour = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tourLearnMoreLink = 'https://ela.st/left-nav';
const LearnMoreLink = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: tourLearnMoreLink,
  target: "_blank",
  external: true
}, _i18n.i18n.translate('xpack.spaces.navControl.tour.learnMore', {
  defaultMessage: 'Learn more'
}));
const solutionMap = {
  es: _i18n.i18n.translate('xpack.spaces.navControl.tour.esSolution', {
    defaultMessage: 'Elasticsearch'
  }),
  security: _i18n.i18n.translate('xpack.spaces.navControl.tour.securitySolution', {
    defaultMessage: 'Security'
  }),
  oblt: _i18n.i18n.translate('xpack.spaces.navControl.tour.obltSolution', {
    defaultMessage: 'Observability'
  }),
  chat: _i18n.i18n.translate('xpack.spaces.navControl.tour.chatSolution', {
    defaultMessage: 'Workchat'
  })
};
const SolutionViewTour = ({
  children,
  solution,
  isTourOpen,
  onFinishTour
}) => {
  const solutionLabel = solution && solution !== _constants.SOLUTION_VIEW_CLASSIC ? solutionMap[solution] : '';
  if (!solutionLabel) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.navControl.tour.content",
      defaultMessage: "It provides all the analytics and {solution} features you need. You can switch views or return to the classic navigation from your space settings, or create other spaces with different views. {learnMore}",
      values: {
        solution: solutionLabel,
        learnMore: /*#__PURE__*/_react.default.createElement(LearnMoreLink, null)
      }
    }))),
    isStepOpen: isTourOpen,
    minWidth: 300,
    maxWidth: 360,
    onFinish: onFinishTour,
    step: 1,
    stepsTotal: 1,
    repositionOnScroll: true,
    title: _i18n.i18n.translate('xpack.spaces.navControl.tour.title', {
      defaultMessage: 'You chose the {solution} solution view',
      values: {
        solution: solutionLabel
      }
    }),
    anchorPosition: "downCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: onFinishTour,
      "data-test-subj": "closeTourBtn"
    }, _i18n.i18n.translate('xpack.spaces.navControl.tour.closeBtn', {
      defaultMessage: 'Close'
    })),
    panelProps: {
      'data-test-subj': 'spaceSolutionTour'
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
};
exports.SolutionViewTour = SolutionViewTour;