"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmDeleteModal = ({
  space,
  onSuccess,
  onCancel,
  spacesManager
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    value: isCurrentSpace
  } = (0, _useAsync.default)(async () => space.id === (await spacesManager.getActiveSpace()).id, [space.id]);
  const [state, deleteSpace] = (0, _useAsyncFn.default)(async () => {
    try {
      await spacesManager.deleteSpace(space);
      services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.successMessage', {
        defaultMessage: "Deleted space ''{name}''",
        values: {
          name: space.name
        }
      }));
      if (isCurrentSpace) {
        spacesManager.redirectToSpaceSelector();
      } else {
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      }
    } catch (error) {
      var _body;
      services.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.errorMessage', {
          defaultMessage: "Could not delete space ''{name}''",
          values: {
            name: space.name
          }
        }),
        text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
      });
    }
  }, [isCurrentSpace]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.title', {
      defaultMessage: "Delete space ''{name}''?",
      values: {
        name: space.name
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: deleteSpace,
    cancelButtonText: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.confirmButton', {
      defaultMessage: '{isLoading, select, true{Deleting space and all contents…} other{Delete space and all contents}}',
      values: {
        isLoading: state.loading
      }
    }),
    buttonColor: "danger",
    isLoading: state.loading
  }, isCurrentSpace && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.spaces.management.confirmDeleteModal.currentSpaceTitle', {
      defaultMessage: 'You are currently in this space.'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.currentSpaceDescription",
    defaultMessage: "Once deleted, you must choose a different space."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.description",
    defaultMessage: "This space and {allContents} will be permanently deleted.",
    values: {
      allContents: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.confirmDeleteModal.allContents",
        defaultMessage: "all contents"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmDeleteModal.cannotUndoWarning",
    defaultMessage: "You can't recover deleted spaces."
  }))));
};
exports.ConfirmDeleteModal = ConfirmDeleteModal;