"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnalyticsContext = registerAnalyticsContext;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAnalyticsContext(analytics, activeSpace) {
  analytics.registerContextProvider({
    name: 'Spaces Metadata',
    context$: activeSpace.pipe((0, _rxjs.map)(space => ({
      spaceSolution: space.solution
    }))),
    schema: {
      spaceSolution: {
        type: 'keyword',
        _meta: {
          description: 'The Space solution view',
          optional: true
        }
      }
    }
  });
}